/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Platform specific definitions for memory mapped files, Linux version
 *
 * $Id: cxiMmap-plat.h,v 1.11 2001/08/21 01:56:30 tee Exp $
 *
 * $Log: cxiMmap-plat.h,v $
 * Revision 1.11  2001/08/21 01:56:30  tee
 * Make AIX and Linux versions of buf queue handling be the same.
 *
 * Revision 1.10  2001/08/18 02:11:32  tee
 * Improve matching between AIX and Linux mmap code to prepare for source file
 * merge.
 *
 * Revision 1.9  2001/08/16 01:26:26  tee
 * Fix dynamic mmap kproc starting and stopping on Linux.  Don't start processes
 * that only live for the duration of a page fault.  Use the daemon startup
 * thread as a master controller for the kprocs, which will wait on them when
 * they exit to keep them from becoming zombies.
 *
 * Revision 1.8  2001/08/14 22:34:02  tee
 * Add CVS version Id and checkin log
 *
 */

#ifndef _h_cxiMmap_plat
#define _h_cxiMmap_plat

#include <cxiTypes.h>

/*  b_flags flags. */
#define B_WRITE     (long)0x0000    /* non-read pseudo-flag */
#define B_READ      (long)0x0001    /* read when I/O occurs */
#define B_ERROR     (long)0x0004    /* error detected */
#define B_PFSTORE   (long)0x2000    /* store operation */
#define B_PFPROT    (long)0x4000    /* protection violation */
#define B_PFEOF     (long)0x10000   /* check for ref. beyond end-of-file */

typedef struct PageQueue
{
  struct  PageQueue *av_forw;  /* forward pointer */
  struct  PageQueue *av_back;  /* backward pointer */
  void    *pageP;              /* pointer to the page being processed */
  struct cxiNode_t *b_vp;
  struct MMFSVInfo *vinfoP;    /* used by sendfile */
  struct gpfsVfsData_t *privVfsP;
  caddr_t b_baddr;             /* kmap(pageP) */
  unsigned long b_flags;       /* page operation flag: read or write */
  int     b_blkno;             /* block number */
  int     b_bcount;
  int     b_error;

} cxibuf_t;

#ifdef __cplusplus
extern "C"
{
#endif /*__cplusplus */
int RegisterPagerBackEnd();
int UnregisterPagerBackEnd();
gpfs_Kpid_t Createpagrkproc(void *iparms);
Int64 getFilePos(cxibuf_t *bufP);
#define VM_Attach(bufP) ((bufP)->b_baddr)
#define VM_Detach(baddrP) do { } while (0)
int MMFlushRange(void *gnP, UInt64 start, UInt64 end, enum MmflushOption mmfopt);
void getVp(void * gnP,void **vP, struct gpfsVfsData_t **privVfsP);
cxibuf_t *getHeadQueue();
void IoDone(cxibuf_t *bufP);
void wakeKprocMaster(cxiPid_t pid);
int gpfsRWpage(struct gpfsVfsData_t *privVfsP, cxiNode_t *cnP,
               struct MMFSVInfo *vinfoP,
               caddr_t kaddr, void * page, int write_req);
#ifdef __cplusplus
}
#endif /*__cplusplus */

extern Simple_lock pagerLock;
extern Boolean kprocsRunning;
extern Boolean mmapAbort;
extern Boolean waitingForFreeEntries;
extern cxiWaitEvent_t pagerEventWord;
extern cxiWaitEvent_t FreeEventWord;

#define MAX_PAGEQUE_ENTRIES 256
extern cxibuf_t PageRunQueue;

#endif  /* _h_cxiMmap_plat */
